<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_Recieptv extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Recieptv')));
        $this->Browse =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Recieptv')));
        $this->Edit =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Recieptv')));
        $this->Delete =  $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Recieptv')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('Accouting_ReceipteV');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/recieptv/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_AE() {

        $par1 = $this->request->param('par1');
        $par2 = $this->request->param('par2');

        $process_type = 'add_new';
        $Obj = ORM::factory('Accounting_Receipt', $par1);

        if ($Obj->loaded()) {
            $process_type = 'modify';
        }

        if ((($this->Add && $process_type == 'add_new') || ($this->Edit && $process_type == 'modify')) && ($Obj->is_deleted == NULL)) {
            if ($process_type == 'add_new') {
                $Current_Term = ORM::factory('Study_Terms', ORM::factory('Variables', 78)->value);
            } elseif ($process_type == 'modify') {
                $Current_Term = ORM::factory('Study_Terms', 0);
            }
            if ($Current_Term->loaded() || TRUE) {
                $this->template->layout = new View('system/accounting/recieptv/AE');

                if ($Obj->loaded()) {
                    $this->template->layout->Obj = $Obj;
                }
                $this->template->layout->Details  = ORM::factory('Accounting_Receipttranse')->where('voucher_id','=',$Obj->id)->find_all();
                $this->template->layout->username = $this->user_online->{'name_'.$this->lang};
                $this->template->layout->title = Lang::__($process_type);
                $this->template->title = Lang::__($process_type);
                $this->template->layout->lang = $this->lang;
                $this->template->layout->Current_Term = $Current_Term;
                $this->template->layout->Users = Search::action_FindAll_To_Array(ORM::factory('User')->find_all());
            } else {
                $this->template->layout = new View('system/show_msg');
                $this->template->layout->class_color = 'danger';
                $this->template->layout->msg = Lang::__('undefined_current_term');
            }
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Accounting_Receipt', $Filtered_array['id']);

            $CheckDeleteRules = $Obj->CheckDeleteRules();
            if ($CheckDeleteRules === TRUE) {
                try {
                    $Obj->is_deleted = 1;
                   
                    if ($Obj->save()) {
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    }
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            } else {
                if (is_array($CheckDeleteRules)) {

                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::ArrayToString($CheckDeleteRules),
                    );
                }
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results);
    }

    public function action_ToDB() {
        $results = array();
        $isAdd = true;
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['par1']) ? NULL : $Filtered_array['par1'];
        $par2 = empty($Filtered_array['par2']) ? NULL : $Filtered_array['par2'];

        $objj = ORM::factory('Accounting_Receipt', $par1);
        $objj_Trans = ORM::factory('Accounting_Accounts_Trans');
        
        if (!$objj->loaded()) {
            
            $objj->Created_By = $this->user_online->id;
            $objj->Created_Date = $Filtered_array['Created_Date'];
        } else {
            $isAdd = false;
            $objj->last_update_by = $this->user_online->id;
            $objj->last_update_date = date("Y-m-d H:i:s");

            $CurrentCash = $objj->Cash;
            $CurrentBank_Transfer = $objj->Bank_Transfer;
            $CurrentATM = $objj->point_of_sales;
            $CurrentCheque = $objj->Cheque;
        }

 $errors = array();

        $objj->debit_id = $Filtered_array['debit_id'];
        $objj->employee_name = $Filtered_array['employee_name'];
        $objj->donor = $Filtered_array['donor'];
        $objj->reference_ID = $Filtered_array['reference_ID'];


        



        $Total_Paid = $Filtered_array['Cash'] + $Filtered_array['Bank_Transfer'] + $Filtered_array['point_of_sales'] + $Filtered_array['Cheque'];
       
        //اذا كان الدفع الادنى مش مطلوب، او اذا كانت الدفعة اكثر من الحد الادنى في حال كان مطلوب
        if ((isset($min_to_pay) && ($Total_Paid >= $min_to_pay)) || !isset($min_to_pay)) {
            $objj->Cash = $Filtered_array['Cash'];
            $objj->Bank_Transfer = $Filtered_array['Bank_Transfer'];
            $objj->point_of_sales = $Filtered_array['point_of_sales'];
            $objj->Cheque = $Filtered_array['Cheque'];

            $objj->check_bank = $Filtered_array['check_bank'];
            $objj->check_number = $Filtered_array['check_number'];
            $objj->check_maturity_date = $Filtered_array['check_maturity_date'];
            
            
            $objj->Bank_Transfer_name = $Filtered_array['Bank_Transfer_name'];
            $objj->Bank_Transfer_number = $Filtered_array['Bank_Transfer_number'];
            $objj->Bank_Transfer_maturity_date = $Filtered_array['Bank_Transfer_maturity_date'];
            $objj->Bank_Transfer_note = $Filtered_array['Bank_Transfer_note'];
            //$objj->values($Filtered_array);
            
            try {
                if ($objj->save()) {
                    
                    if($isAdd){
                        $objj_Trans->Created_by = $this->user_online->id;
                        $objj_Trans->Created_date = date("Y-m-d H:i:s");
                        $objj_Trans->amount = $Total_Paid;
                        $objj_Trans->Gregorian_date = date("Y-m-d H:i:s");
                        $objj_Trans->Document_Number = $objj->id;
                        $objj_Trans->Description = 'قيد الي من سند القبض';
                        $objj_Trans->isFromVoucher = 1;
                        if($objj_Trans->save()){
                            
                        }
                    }
                    $Details = $this->action_ModifyDetailsArray(json_decode(stripslashes($Filtered_array['array_of_table'])),$Total_Paid);
                    if (!is_array($Details)) {
                
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => $Details
                );
            }else{
                    foreach($Details as $key=>$val){
                        if($key != 0){
                            $trans = ORM::factory('Accounting_Receipttranse',$par1);
                            $trans->voucher_id = $objj->id;
                            $trans->credit = $val[4]; 
                            $trans->AccNo = $val[1];
                            $trans->CostCenterno = $val[2];
                            $trans->note = $val[3];
                            $trans->save();
                            $objj_Trans_datails = ORM::factory('Accounting_Accounts_Transdetail');
                            $objj_Trans_datails->TransNo = $objj_Trans->id;
                            $objj_Trans_datails->AccNo = $val[1];
                            $objj_Trans_datails->CostCenterno = $val[2];
                            $objj_Trans_datails->Description = 'سند قبض';
                            $objj_Trans_datails->debit = $Total_Paid;
                            $objj_Trans_datails->credit = $val[4];
                            $objj_Trans_datails->save();
                        }
                    }
                    
                    $results['Success'] = array(
                        'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                        'horizontalEdge' => 'top', //top,bottom
                        'verticalEdge' => 'right', //right,left
                        'heading' => '',
                        'life' => '2000', //1000 is 1 second
                        'text' => Lang::__('Saved_successfully'),
                    );
            }
                }
            } catch (ORM_Validation_Exception $e) {

                $errors = $e->errors('');
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => General::ArrayToString(General::CatchErrorMSGSAjax($errors))
                );
            }
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('total_paid') . ' (' . $Total_Paid . ') ' . Lang::__('less_than_required_amount') . ' (' . $min_to_pay . ')'
            );
        }

        
        echo json_encode($results);
    }

  public function action_ModifyDetailsArray($data , $debit) {
        //echo ($data).'Data';
        //exit();
        /*
         * [0] id
         * [1] AccNo
         * [2] CostCenter
         * [3] description
         * [4] depit
         * [5] Credit
         */
        unset($data[0]); //delete first empty array
        $total_debit = 0;
        $total_Credit = 0;
        foreach ($data as $key => $value) {
            if (!is_numeric($value[0])) { //if id not loaded
                $data[$key][0] = NULL;
            }
            if (!is_numeric($value[1])) { //if AccNo not loaded
                unset($data[$key]);
                continue;
            }
            if (!is_numeric($value[2])) { //if CostCenter not correct
                $data[$key][2] = NULL;
            }
            if (!is_numeric($value[4])) { //if depit not num
                $data[$key][4] = 0;
            }
            if (!is_numeric($value[5])) { //if Credit not num
                $data[$key][5] = 0;
            }
            $total_debit += $value[4];
            $total_Credit += $value[5];
            
            if ($value[1] <= 0) {
                return Lang::__('You_must_enter_account');
            }
            if ($value[4] < 0 || $value[5] < 0) {
                return Lang::__('You_cant_enter_value_less_than_0');
            }
            if ($value[4] > 0 && $value[5] > 0) {
                return Lang::__('debit_of_credit_must_be_equal_0');
            }
            
            /*if ($value[4] == 0 && $value[5] == 0) {
                return Lang::__('debit_and_credit_should_not_be_same_0');
            }*/
        }
        
        $diff_deb_cre = $debit - $total_debit;
        if ($total_debit <= 0 && $total_Credit <= 0) {
            return Lang::__('You_must_enter_details');
        } elseif ($diff_deb_cre != 0) {
            return Lang::__('the_difference_between_the_sum_of_the_creditor_and_the_debtor_is_not_equal_to_zero');
        } else {
            return $data;
        }
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Accounting_Receipt')
                ->where('is_deleted', '=', NULL)
                ->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir']);



        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':


                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['accname'])) {
                $ID_No = $post['accname'];
                $All_ORM->where('debit_id', '=', $ID_No);
            }
            if (!empty($post['accid'])) {
                $academic_no = $post['accid'];
                $All_ORM->where('debit_id', '=', $academic_no);
            }
            if (!empty($post['academic_no'])) {
                $All_ORM->where('reference_ID', '=', $post['academic_no']);
            }
            
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);



        /*
         * Prepare JSON Array
         */

        foreach ($All_ORM->find_all() as $value) {
           //print_r($value);
            $buttons = '';
            ($this->Browse) ? $buttons.='<a target="_blank" href="' . URL::base() . 'Print/Accounting_Recieptv/' . $value->id . '" class="btn btn-xs purple"><i class="fa fa-print"></i> ' . Lang::__('print') . '</a>' : NULL;
            ($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Accounting_Recieptv/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            ($this->Delete && ($value->CheckDeleteRules() === TRUE)) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            $acc = ORM::factory('Accounting_Accounts')->where('id' , '=' , $value->debit_id)->find();
            
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $acc->{'AccName_' . $this->lang},
                $acc->AccNo,
                $value->reference_ID,
                $value->Cash + $value->Bank_Transfer + $value->point_of_sales + $value->Cheque,
                $buttons,
            );   
            
            /*$records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->Student->Student_Information->ID_No,
                $value->accounting_accounts->{'AccName_' . $this->lang},
                $value->Student->username,
                //$value->Term->{'name_' . $this->lang},
                $value->Cash + $value->Bank_Transfer + $value->ATM + $value->Cheque,
                $buttons,
            );*/
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

}
