<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Accounting_Accounts extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;
    public $A_Payables = FALSE;
    public $E_Payables = FALSE;
    public $B_Payables = FALSE;
    public $D_Payables = FALSE;
    public $A_Receivables = FALSE;
    public $E_Receivables = FALSE;
    public $B_Receivables = FALSE;
    public $D_Receivables = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Accounting_Accounts')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Accounting_Accounts')));
        $this->Edit = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Accounting_Accounts')));
        $this->Delete = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Accounting_Accounts')));

        $this->A_Payables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Payables')));
        $this->E_Payables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Payables')));
        $this->B_Payables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Payables')));
        $this->D_Payables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Payables')));

        $this->A_Receivables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_Receivables')));
        $this->E_Receivables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'E_Receivables')));
        $this->B_Receivables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_Receivables')));
        $this->D_Receivables = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'D_Receivables')));
    }

    /*
     * جدول الحسابات
     */

    public function action_index() {

        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $msg = mb_strtolower($this->request->param('par1'));
            $title = Lang::__('Accounts_Table');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/accounts/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->msg = $msg;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * عرض تفاصيل الحساب
     */

    public function action_ViewAccount() {
        $post = $this->request->post();
        $id = NULL;
        if (isset($post['AccID'])) {
            $id = $post['AccID'];
        }
        $Obj = ORM::factory('Accounting_Accounts', $id);

        $view = View::factory('system/accounting/accounts/View_account_details');
        if ($Obj->loaded()) {
            $view->set('Obj', $Obj);
        }
        $view->set('lang', $this->lang);
        $this->response->body($view);
    }

    /*
     * عرض كشف الحساب
     */

    public function action_View_Account_Statement() {
        $post = $this->request->post();
        $id = NULL;
        if (isset($post['AccID'])) {
            $id = $post['AccID'];
        }
        $Obj = ORM::factory('Accounting_Accounts', $id);


        if ($Obj->loaded()) {
            $view = View::factory('system/accounting/accounts/View_Account_Statement');
            $view->set('Obj', $Obj);
            $view->set('lang', $this->lang);
            $this->response->body($view);
        }
    }
    
    public function checkACCTrans($acc_id = 0){
        if(!Accounts::isParent($acc_id)){
            $Obj = ORM::factory('Accounting_Accounts',$acc_id);
            if($Obj->loaded()){
                if(Accounts::Move_on_account($Obj) === FALSE)
                    return true;
                else
                    return false;
            }else{
                return FALSE;
            }
        }else{
            return FALSE;
        }
    }
    public function action_Delete() {
        $results = array();

        if ($this->Delete) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Accounting_Accounts', $Filtered_array['id']);
                try {
                    $Obj->delete();
                   
                    
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error'),
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results); 
    }
    /*
     * نافذة تحرير الحساب
     */

    public function action_AEObjAjax() {
        $req = Request::current();
        $Filtered_array = Search::action_Filtered_array($req->post());

        $type_of_account = NULL;
        $type_of_account_word = isset($Filtered_array['type_of_account']) ? mb_strtolower($Filtered_array['type_of_account']) : NULL;
        if ($type_of_account_word == 'payable') {
            $type_of_account = 2;
        } elseif ($type_of_account_word == 'recievable') {
            $type_of_account = 1;
        }
        $id = NULL;
        if (isset($Filtered_array['AccID'])) {
            $id = $Filtered_array['AccID'];
        }
        if (!is_numeric($id)) {
            $ex = explode(':', $id);
            $parent = $ex[0];
            $id = null;
        }

        $Obj = ORM::factory('Accounting_Accounts', $id);

        $Parent_payable = FALSE;
        if ($type_of_account == 2) { //لتحديد حساب الاب الخاص بالذمم الدائنة
            $Accounting_Links_11 = ORM::factory('Accounting_Links', 11);
            if ($Accounting_Links_11->loaded() && !empty($Accounting_Links_11->account_id)) {
                $Parent_payable = TRUE;
            }
        }
        $Parent_recievable = FALSE;
        if ($type_of_account == 1) { //لتحديد حساب الاب الخاص بالذمم الدائنة
            $Accounting_Links_10 = ORM::factory('Accounting_Links', 10);
            if ($Accounting_Links_10->loaded() && !empty($Accounting_Links_10->account_id)) {
                $Parent_recievable = TRUE;
            }
        }

        if (($this->Add && empty($type_of_account) && !$Obj->loaded()) || ($this->Edit && $Obj->loaded() && empty($Obj->type_of_account)) || ($this->E_Payables && $Obj->loaded() && $Obj->type_of_account == 2) || ($this->A_Payables && $Parent_payable && (!$Obj->loaded()) && ($type_of_account == 2)) || ($this->E_Receivables && $Obj->loaded() && $Obj->type_of_account == 1) || ($this->A_Receivables && $Parent_recievable && (!$Obj->loaded()) && ($type_of_account == 1))) {
            $title = Lang::__('Create new account');
            if ($type_of_account == 1) {
                $title = Lang::__('Add_New_Receivable_Account');
            }
            if ($type_of_account == 2) {
                $title = Lang::__('Add_New_Payable_Account');
            }
            $view = View::factory('system/accounting/accounts/AE_Ajax');
            if ($Obj->loaded()) {
                $type_of_account = $Obj->type_of_account;
                $title = Lang::__('modify_account');
                if ($Obj->type_of_account == 1) {
                    $title = Lang::__('Edit_Receivable_Account');
                }
                if ($Obj->type_of_account == 2) {
                    $title = Lang::__('Edit_Payable_Account');
                }
                $view->set('Obj', $Obj);
            } else {
                //Create auto account number
                $New_Acc_id = '';
                if (isset($parent) && !empty($parent)) {
                    echo 1;
                    $Parent_Obj = ORM::factory('Accounting_Accounts', $parent);
                    if ($Parent_Obj->loaded()) {
                        $New_Acc_id = $Parent_Obj->AccNo;
                        $CountPrev = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('ParentNo', '=', $Parent_Obj->id)->count_all();
                        $CountPrev++;
                        $New_Acc_id .= '.' . $CountPrev;


                        while (TRUE) {
                            $Check = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('AccNo', '=', $New_Acc_id)->find();
                            if ($Check->loaded()) {
                                echo 2;
                                $CountPrev++;
                                $New_Acc_id = $Parent_Obj->AccNo . '.' . $CountPrev;
                            } else {
                                break;
                            }
                        }
                    }
                } elseif ($Parent_payable) {
                    $New_Acc_id = $Accounting_Links_11->Account->AccNo;
                    $CountPrev = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('ParentNo', '=', $Accounting_Links_11->account_id)->count_all();
                    $CountPrev++;
                    $New_Acc_id .= '.' . $CountPrev;

                    while (TRUE) {
                        $Check = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('AccNo', '=', $New_Acc_id)->find();
                        if ($Check->loaded()) {
                            $CountPrev++;
                            $New_Acc_id = $Check->AccNo . '.' . $CountPrev;
                        } else {
                            break;
                        }
                    }
                } elseif ($Parent_recievable) {
                    $New_Acc_id = $Accounting_Links_10->Account->AccNo;
                    $CountPrev = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('ParentNo', '=', $Accounting_Links_10->account_id)->count_all();
                    $CountPrev++;
                    $New_Acc_id .= '.' . $CountPrev;

                    while (TRUE) {
                        $Check = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('AccNo', '=', $New_Acc_id)->find();
                        if ($Check->loaded()) {
                            $CountPrev++;
                            $New_Acc_id = $Check->AccNo . '.' . $CountPrev;
                        } else {
                            break;
                        }
                    }
                } else {
                    $CountPrev = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('ParentNo', '=', 0)->count_all();
                    $CountPrev++;
                    $New_Acc_id = $CountPrev;

                    while (TRUE) {
                        $Check = ORM::factory('Accounting_Accounts')->where('is_deleted', '=', NULL)->where('AccNo', '=', $New_Acc_id)->find();
                        if ($Check->loaded()) {
                            $CountPrev++;
                            $New_Acc_id = $CountPrev;
                        } else {
                            break;
                        }
                    }
                }
                $view->set('New_Acc_id', $New_Acc_id);
            }
            if (isset($parent)) {
                $view->set('parent', $parent);
            }
            $view->set('lang', $this->lang);
            $view->set('title', $title);
            $view->set('type_of_account', $type_of_account);



            $this->response->body($view);
        } else {


            if (!($this->A_Payables && $Parent_payable && (!$Obj->loaded()) && ($type_of_account == 2)) && !$Parent_payable) {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('Please_Link_Account_For_Payables'));
                $this->response->body($view);
            } elseif (!($this->A_Receivables && $Parent_recievable && (!$Obj->loaded()) && ($type_of_account == 1)) && !$Parent_recievable) {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('Please_Link_Account_For_recievable'));
                $this->response->body($view);
            } else {
                $view = View::factory('system/error_modal');
                $view->set('MSG', Lang::__('You_dont_have_permission_to_access_this_page'));
                $this->response->body($view);
            }
        }
    }

    /*
     * شجرة الحسابات
     */

    public function action_ShowTree() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $msg = mb_strtolower($this->request->param('par1'));
            $title = Lang::__('Accounting_tree');
            $this->template->title = $title;
            $this->template->layout = new View('system/accounting/accounts/show_tree');
            $this->template->layout->title = $title;
            $this->template->layout->msg = $msg;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    /*
     * انشاء الشجرة بالاجاكس
     */

    public function action_GetTree() {
        $lang = $this->lang;

        $records = array();
        $records['nodes'] = array();

        $id = isset($_REQUEST['id']) ? $_REQUEST['id'] : '0';
        $level = 1;
        if ($id != '0') {
            $id = explode(':', $id);
            $level = $id[1] + 1;
            $id = $id[0];
        }

        //find all Accounts
        $Accounts = ORM::factory('Accounting_Accounts')->order_by('id','ASC')->find_all();

        // Convert Object to array
        $array_ = array(); //MD-array of All accounts
        $outputs = array(); //this array will contain all cuurent nodes id
        foreach ($Accounts as $k => $d) {
            if($id == '0' && $d->ParentNo == null){
                array_push($outputs, $d->id);
            }else
            
            if ($d->ParentNo == $id) {
                
                array_push($outputs, $d->id);
            }
            $array_[$k] = $d->as_array();
        }


        $Search_objs = array();
        foreach ($outputs as $value) {
            array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
        }
        $counter = 1;
        foreach ($Search_objs as $key => $value) {
            $all_childs = Search::action_GetALL($array_, 'ParentNo', $value['id']);
            $type = "folder";
            if (count($all_childs) <= 0) {
                $type = "LastChild";
            }
            $le = $value['id'] . ':' . ($level);
            $records['nodes'][] = array('id' => $le, 'parent' => $id ,'sortID'=> $counter, 'name' => ' '.$value['AccNo'].' '.$value['AccName_' . $lang], 'level' => $level, 'type' => $type);
            $counter++;
            
            }
        echo json_encode($records);
    }

    /*
     * حذف حساب
     */

    public function action_DeleteNode($id = NULL) {
        $post = $this->request->post();
        if (isset($id) && is_numeric($id)) { //الحساب من الجدول
            $obj = ORM::factory('Accounting_Accounts', $id);
        } else { //الحساب من الشجرة
            $id_of_element = explode(':', $post['id']);
            $obj = ORM::factory('Accounting_Accounts', $id_of_element[0]);
            $From_tree = TRUE;
        }
        if ($obj->loaded()) {
            $All_acount = ORM::factory('Accounting_Accounts')
                    ->where('ParentNo', '=', $obj->id)
                    ->count_all();
            if ($All_acount > 0) { //node has chlids
                if (isset($From_tree)) { //اذا كان العنصر من الشجرة
                    $result['Error'] = Lang::__('The_accounts_have_not_been_deleted_since_it_falls_below_sons');
                    echo json_encode($result);
                } else {
                    return FALSE;
                }
            } else {
                if (Accounts::Move_on_account($obj) === FALSE) { //النفي يعني انه لم يحدث عليه حركات
                    $id_acc = $obj->id;
                    $obj->delete();
                    //Reports::AddReport('Accounts', 'delete', $id_acc); //تسجيل تقرير بالعملية
                } else {
                    if (isset($From_tree)) { //اذا كان العنصر من الشجرة
                        $result['Error'] = Lang::__('Account_have_not_been_deleted_since_it_was_conducted_by_movements');
                        echo json_encode($result);
                    } else {
                        return FALSE;
                    }
                }
            }
        }
// delete all sons ,,,
//        if ($obj->loaded()) {
//            $sons = array();
//            array_push($sons, $obj->id);
//            for ($x = 0; $x <= 50; $x++) {
//                foreach ($sons as $value) {
//                    $all_son = ORM::factory('Accounting_Accounts')
//                            ->where('ParentNo', '=', $value)
//                            ->find_all();
//                    foreach ($all_son as $son) {
//                        if (!in_array($son->id, $sons)) {
//                            array_push($sons, $son->id);
//                        }
//                    }
//                }
//            }
//
//            foreach ($sons as $id_to_delete) {
//                ORM::factory('Accounting_Accounts', $id_to_delete)->delete();
//            }
//        }
    }

    public function action_AEobj() {
        $lang = $this->lang;
        $view = View::factory('system/accounts/AE');
        $id = $this->request->param('par1');

        if (!is_numeric($id)) {
            $ex = explode(':', $id);
            $parent = $ex[0];
            $id = null;
        }
        $obj = ORM::factory('Accounting_Accounts', $id);
        $title_of_page = Lang::__('Add_new_element');
        if ($obj->loaded()) {
            $view->set('Obj', $obj);

            $title_of_page = $obj->{'AccName_' . $lang};
        }
        if (isset($parent)) {
            $view->set('parent', $parent);
        }
        $view->set('title_of_page', $title_of_page);
        $this->response->body($view);
    }

    /*
     * جلب بيانات حساب معين للاجاكس
     */

    public function action_GetAccountDetails() {
        $id = $this->request->param('par1');
        $obj = ORM::factory('Accounting_Accounts', $id);
        if ($obj->loaded()) {
            $arr = array(
                'ACCNo' => $obj->AccNo,
                'AccName_ar' => $obj->{'AccName_ar'},
                'AccName_en' => $obj->{'AccName_en'},
            );
            
        }else{
            $arr = array('notload'=>true);
        }
        echo json_encode($arr);
    }

    /*
     * تصدير وطباعة البيانات
     */

    public function action_ExportToFile($File_Type, $array_to_excel) {
        $lang = $this->lang;
        $dir = 'ltr';
        if ($lang == 'ar') {
            $dir = 'rtl';
        }
        $user_id = $this->user_online->id;

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getDefaultStyle()->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);


        $All_data = $objPHPExcel->setActiveSheetIndex(0);
        $All_data->setCellValue('A1', Lang::__('AccNo'));
        $All_data->setCellValue('B1', Lang::__('AccName_ar'));
        $All_data->setCellValue('C1', Lang::__('AccName_en'));
        $All_data->setCellValue('D1', Lang::__('AccType'));
        $All_data->setCellValue('E1', Lang::__('Credit_limit'));
        $All_data->setCellValue('F1', Lang::__('Phone'));
        $All_data->setCellValue('G1', Lang::__('Fax'));
        $All_data->setCellValue('H1', Lang::__('Mobile'));
        $All_data->setCellValue('I1', Lang::__('Selling_price'));

        $AccType = array(
            '1' => Lang::__('Profits_and_losses'),
            '2' => Lang::__('budget'),
        );
        $row = 2;
        foreach ($array_to_excel as $value) {

            $All_data->setCellValue('A' . $row, $value['AccNo']);
            $All_data->setCellValue('B' . $row, $value['AccName_ar']);
            $All_data->setCellValue('C' . $row, $value['AccName_en']);
            $All_data->setCellValue('D' . $row, $AccType[$value['AccType']]);
            $All_data->setCellValue('E' . $row, $value['CreditLimit']);
            $All_data->setCellValue('F' . $row, $value['Phone']);
            $All_data->setCellValue('G' . $row, $value['Fax']);
            $All_data->setCellValue('H' . $row, $value['Mobile']);
            $All_data->setCellValue('I' . $row, Lang::__('Selling_price' . $value['Selling_price']));



            $row++;
        }


        $objPHPExcel->setActiveSheetIndex(0)->getStyle('A1:I1')->applyFromArray(
                array(
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => array('rgb' => 'EAF7EE')
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN
                        )
                    ),
                    'font' => array(
                        'bold' => true,
                        'color' => array('rgb' => '1A00C6'),
                        'size' => 10,
                    ),
                )
        );


        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        // Set Orientation, size and scaling
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation("L");
        $objPHPExcel->getActiveSheet()->getPageSetup()->setPaperSize(PHPExcel_Worksheet_PageSetup::PAPERSIZE_A4);
        $objPHPExcel->getActiveSheet()->getPageSetup()->setFitToPage(true);
        $objPHPExcel->getActiveSheet()->getPageSetup()->setFitToWidth(1);
        $objPHPExcel->getActiveSheet()->getPageSetup()->setFitToHeight(0);


        if ($dir == 'rtl') {
            $objPHPExcel->getActiveSheet()->setRightToLeft(true); //للنسخة العربية
        }

        /*
         * Determaine type of export
         */

        switch ($File_Type) {
            case 'Excel':
                $method = 'Excel2007';
                $ext = 'xlsx';
                break;

            case 'PDF':
                $method = 'PDF';
                $ext = 'pdf';
                break;
            case 'Print':
                $method = 'HTML';
                $ext = 'html';
                break;

            default:
                break;
        }

        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, $method);
        $folder_path = 'files/users/' . $user_id . '/' . $ext . '/';
        $file_path = $folder_path . Text::random('alnum', rand(10, 50)) . '.' . $ext;

        if (!file_exists(DOCROOT . $folder_path)) {
            mkdir(DOCROOT . $folder_path, 0777, true);
        }

        $objWriter->save(DOCROOT . $file_path);
        return $file_path;
    }

    /*
     * انشاء جدول كشف الحساب
     */

    public function action_GetDateToAccountStatmentTable() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        $account_id = $this->request->param('par1');
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "AccNo",
            2 => "AccName_ar",
            3 => "AccName_en",
            4 => "AccType",
            5 => "id",
        );

        // $Accounts = ORM::factory('Accounting_Accounts')->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();
        // Convert Object to array
        $array_ = array(); //MD-array of All accounts
        $array_All_with_temp = array(); //تحتوي هذه المصفوفة على كل شيء
        
        $Temp = "";
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if($post['date_from'] != '' && $post['date_to'] != ''){
                $Temp = ORM::factory('Accounting_Accounts_Trans')
                    ->where('Gregorian_date','>',$post['date_from'])
                    ->where('Gregorian_date','<',$post['date_to'])
                    ->find_all();
            }else if($post['date_from'] != '' && $post['date_to'] == ''){
                $Temp = ORM::factory('Accounting_Accounts_Trans')
                    ->where('Gregorian_date','>',$post['date_from'])
                    
                    ->find_all();
            }else if($post['date_from'] == '' && $post['date_to'] != ''){
                $Temp = ORM::factory('Accounting_Accounts_Trans')
                    ->where('Gregorian_date','<',$post['date_to'])
                    ->find_all();
            }else{
                $Temp = ORM::factory('Accounting_Accounts_Trans')->find_all();
            }
            
        }else{
            $Temp = ORM::factory('Accounting_Accounts_Trans')->order_by('id','DESC')->find_all();
        }
        $Trans = Search::action_FindAll_To_Array($Temp);
        $Transdetails = Search::action_FindAll_To_Array(ORM::factory('Accounting_Accounts_Transdetail')->find_all());

        foreach ($Transdetails as $value) {
            
            if ($value['AccNo'] == $account_id) {
                
                $ThisTrans = Search::action_GetOne($Trans, 'id', $value['TransNo']);
                if($ThisTrans['Gregorian_date'] != null){
                $arr = Array
                    (
                    'date' => $ThisTrans['Gregorian_date'],
                    'type' => 'Trans',
                    'number' => $value['TransNo'],
                    'description' => $value['Description'],
                    'debit' => $value['debit'],
                    'credit' => $value['credit'],
                    'temp' => $value['posted'], //1 تعني مؤقت
                );
                if ($value['posted'] == 1) {
                    array_push($array_, $arr);
                }
                array_push($array_All_with_temp, $arr);}
            }
        }
        
        /*//Sort Arrays by date
        usort($array_, function($a, $b) {
            return strtotime($a['date']) - strtotime($b['date']);
        });
        usort($array_All_with_temp, function($a, $b) {
            return strtotime($a['date']) - strtotime($b['date']);
        });*/
        // اعداد بعض الحسابات المعلقة بكشف الحساب
        $blnc = 0;
        $id = 1;
        foreach ($array_ as $key => $value) {
            $blnc += $value['debit'] - $value['credit'];
            $array_[$key]['Balance'] = $blnc;
            $array_[$key]['id'] = $id;
            $id++;
        }
        $blnce = 0;
        $id = 1;
        foreach ($array_All_with_temp as $key => $value) {
            $blnce += $value['debit'] - $value['credit'];
            $array_All_with_temp[$key]['Balance'] = $blnce;
            $array_All_with_temp[$key]['id'] = $id;
            $id++;
        }
        // نهاية الاعداد
        // End Sort Arrays by date
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";


        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $error_nodes = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_DeleteNode($value) === FALSE) {
                            array_push($error_nodes, $value);
                        }
                    }

                    if (count($error_nodes) > 0) {
                        $C_Acti_status = "NotOK"; // pass custom message(useful for getting status of group actions)
                        $Succesful_msg = Lang::__('The_following_accounts_have_not_been_deleted_since_it_falls_below_sons') . ":";

                        foreach ($error_nodes as $value1) {
                            $Succesful_msg .= "<div> <i class='fa fa-times icon-default'></i> " . Lang::__('AccNo') . ": " . ORM::factory('Accounting_Accounts', $value1)->AccNo . "</div>";
                        }
                    }

                    break;

                case 'ExportToExcel':
                    $array_to_excel = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_excel, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Excel', $array_to_excel);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';
                    break;

                case 'ExportToPDF':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('PDF', $array_to_pdf);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;
                case 'Print':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Print', $array_to_pdf);
                    $Succesful_msg = Lang::__('Successfully_prepared_print_file');
                    $Succesful_msg .= " <a target='_blank' href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;

                default:
                    break;
            }
        }


        /*
         * Paging
         */

        
        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (isset($post['Temp'])) {
                $Search_objss = $array_All_with_temp;
            } else {
                $Search_objss = $array_;
            }
            
            $array_1 = array();
            $what_to_search = array(); //ما هي العناصر التي سنبحث فيها
            $pp_Balance = 0;
            foreach ($Search_objss as $value) {
                
                //DATE Compare
                $DB_Time = strtotime($value['date']);
                $timeFrom = strtotime($post['date_from']);
                $timeTo = strtotime($post['date_to']);
                $If_Date = FALSE;
                switch (TRUE) {
                    case (is_numeric($timeFrom) && is_numeric($timeTo) && ($DB_Time >= $timeFrom && $DB_Time <= $timeTo)):
                        $If_Date = TRUE;
                        array_push($what_to_search, 'If_Date');
                        break;
                    case (!is_numeric($timeFrom) && is_numeric($timeTo) && ($DB_Time <= $timeTo)):
                        array_push($what_to_search, 'If_Date');
                        $If_Date = TRUE;
                        break;
                    case (is_numeric($timeFrom) && !is_numeric($timeTo) && ($DB_Time >= $timeFrom)):
                        array_push($what_to_search, 'If_Date');
                        $If_Date = TRUE;
                        break;
                    case (is_numeric($timeFrom) || is_numeric($timeTo)):
                        array_push($what_to_search, 'If_Date');
                        break;
                    default:
                        break;
                }
                //End DATE Compare
               // print_r($what_to_search);
                $general = array(); //True Or False
                foreach ($what_to_search as $thing) {
                    array_push($general, $thing);
                }
                
                $prev_balance = 0;
                if (!in_array(FALSE, $general)) { //Sure if all is true (&&)
                    array_push($array_1, $value['id']);

                    if ($If_Date && $prev_balance == 0) {
                        $prev_balance = $pp_Balance;
                    }
                }
                if ($If_Date) {
                    $pp_Balance = $value['Balance'];
                }
            }
            $TypeDo = "search";
        }
        /*
         * if isnot search
         */ else {
            $TypeDo = "get_all";
        }
        
        $total_Debit = 0; //اجمالي المدين
        $total_Credit = 0; //اجمالي الدائن
        $Current_Blnc = 0; // الرصيد الحالي
        if ($TypeDo == "search") {
            
            $iTotalRecords = count($array_1);
            $TheARROBJ = array();
            foreach ($array_1 as $value) {
                array_push($TheARROBJ, Search::action_GetOne($Search_objss, 'id', $value));
            }
            foreach ($TheARROBJ as $value) {
                $total_Credit += $value['credit'];
                $total_Debit += $value['debit'];
            }
            $EndA = end($TheARROBJ);
            $Current_Blnc = $EndA['Balance'];
        } elseif ($TypeDo == "get_all") {
            $iTotalRecords = count($array_All_with_temp);
            foreach ($array_All_with_temp as $value) {
                $total_Credit += $value['credit'];
                $total_Debit += $value['debit'];
            }
            $EndB = end($array_All_with_temp);
            $Current_Blnc = $EndB['Balance'];
        }

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;


        if ($TypeDo == "search") {
            
            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
            }
           
        } elseif ($TypeDo == "get_all") {
            $Search_objs = array_slice($array_All_with_temp, $iDisplayStart, $iDisplayLength);
        }
        
        /*
         * Prepare JSON Array
         */
        
        foreach ($Search_objs as $key => $value) {
            $records["data"][] = array(
                $value['date'],
                Lang::__($value['type']),
                $value['number'],
                $value['description'],
                $value['debit'],
                $value['credit'],
                $value['Balance'],
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;


        $records["prev_balance"] = isset($pp_Balance) ? $pp_Balance : 0;
        $records["TotDebit"] = $total_Debit;
        $records["TotCredit"] = $total_Credit;
        $records["Current_Blnc"] = $Current_Blnc;
        
        echo json_encode($records);
    }

    /*
     * انشاء جدول الحسابات
     */

    public function action_GetDateToTable() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable

        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "AccNo",
            2 => "AccName_ar",
            3 => "AccName_en",
            4 => "AccType",
            5 => "id",
        );

        if (!empty($post['par1'])) {
            $Accounts = ORM::factory('Financials_Receivable')->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();
        } else {
            $Accounts = ORM::factory('Accounting_Accounts')->order_by($ALL_coulums[$order[0]['column']], $order[0]['dir'])->find_all();
        }

        // Convert Object to array
        $array_ = array(); //MD-array of All accounts
        foreach ($Accounts as $k => $d) {
            $array_[$k] = $d->as_array();
        }
        // End Convert Object to array 

        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";


        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':
                    $error_nodes = array();
                    foreach ($post['id'] as $value) {
                        if ($this->action_DeleteNode($value) === FALSE) {
                            array_push($error_nodes, $value);
                        }
                    }

                    if (count($error_nodes) > 0) {
                        $C_Acti_status = "NotOK"; // pass custom message(useful for getting status of group actions)
                        $Succesful_msg = Lang::__('The_following_accounts_have_not_been_deleted_since_it_falls_below_sons') . ":";

                        foreach ($error_nodes as $value1) {
                            $Succesful_msg .= "<div> <i class='fa fa-times icon-default'></i> " . Lang::__('AccNo') . ": " . ORM::factory('Accounting_Accounts', $value1)->AccNo . "</div>";
                        }
                    }

                    break;

                case 'ExportToExcel':
                    $array_to_excel = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_excel, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Excel', $array_to_excel);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';
                    break;

                case 'ExportToPDF':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('PDF', $array_to_pdf);
                    $Succesful_msg = Lang::__('Export_the_file_has_been_successfully');
                    $Succesful_msg .= " <a href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;
                case 'Print':
                    $array_to_pdf = array();
                    foreach ($post['id'] as $value) {
                        array_push($array_to_pdf, Search::action_GetOne($array_, 'id', $value));
                    }
                    $path = $this->action_ExportToFile('Print', $array_to_pdf);
                    $Succesful_msg = Lang::__('Successfully_prepared_print_file');
                    $Succesful_msg .= " <a target='_blank' href='" . URL::base() . $path . "'>" . Lang::__('by_click_here') . "</a>";
                    $Succesful_msg .= '<div class="desc"><span class="label label-sm label-warning " style="margin:2px;"><span>' . Lang::__('Note') . '</span></span>' . Lang::__('File_been_added_to_your_portfolio_files') . ' </div>';

                    break;

                default:
                    break;
            }
        }


        /*
         * Paging
         */

        $iTotalRecords = count($Accounts);

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;
        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {

            $Search_objss = $Accounts;
            $array_1 = array();
            foreach ($Search_objss as $value) {
                if (( (strlen($post['AccNo']) > 1) && (strpos(mb_strtolower($value->AccNo), mb_strtolower($post['AccNo'])) !== false)) || ( (strlen($post['AccName_ar']) > 1) && (strpos(mb_strtolower($value->AccName_ar), mb_strtolower($post['AccName_ar'])) !== false)) || ( (strlen($post['AccName_en']) > 1) && (strpos(mb_strtolower($value->AccName_en), mb_strtolower($post['AccName_en'])) !== false)) || ( $value->AccType == $post['AccType'] )
                ) {
                    array_push($array_1, $value->id);
                }
            }

            $output = array_slice($array_1, $iDisplayStart, $iDisplayLength);
            $Search_objs = array();
            foreach ($output as $value) {
                array_push($Search_objs, Search::action_GetOne($array_, 'id', $value));
            }
        }
        /*
         * if isnot search
         */ else {
            $Search_objs = array_slice($array_, $iDisplayStart, $iDisplayLength);
        }

        /*
         * All account type
         */
        $AccType = array(
            '1' => Lang::__('Profits_and_losses'),
            '2' => Lang::__('budget'),
        );

        /*
         * Prepare JSON Array
         */
        foreach ($Search_objs as $key => $value) {
            $buttons = '';
            $buttons .= '<button Accid="' . $value['id'] . '" class="btn btn-xs blue EditAccount">' . Lang::__('Edit') . '</button>';
            $buttons .= '<button Accid="' . $value['id'] . '" class="btn btn-xs blue-madison ViewAccount">' . Lang::__('View') . '</button>';
            $buttons .= '<button Accid="' . $value['id'] . '" class="btn btn-xs purple View_Account_Statement">' . Lang::__('Account_Statement') . '</button>';
            if($this->checkACCTrans($value['id'])){
                ($this->Delete ) ? $buttons .= '<a par1="' . $value['id'] . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            }
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value['id'] . '">',
                $value['AccNo'],
                $value['AccName_ar'],
                $value['AccName_en'],
                isset($value['AccType']) ? $AccType[$value['AccType']] : NULL,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    /*
     * نقل البيانات الى قاعدة البيانات
     */

    public function action_ObjToDB() {
        $results = array(); //مصفوفة نتائج الجسون

        $obj_id = $this->request->param('par1');
        $objj = ORM::factory('Accounting_Accounts', $obj_id);

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        if (empty($Filtered_array['ParentNo'])) {
            $Filtered_array['ParentNo'] = NULL;
        }
        $type_of_account = isset($Filtered_array['type_of_account']) ? mb_strtolower($Filtered_array['type_of_account']) : NULL;

        $Parent_payable = FALSE;
        if (isset($Filtered_array['type_of_account']) && $Filtered_array['type_of_account'] == 2) {  //لتحديد حساب الاب الخاص بالذمم الدائنة
            $Accounting_Links_11 = ORM::factory('Accounting_Links', 11);
            if ($Accounting_Links_11->loaded() && !empty($Accounting_Links_11->account_id)) {
                $Parent_payable = TRUE;
                $Filtered_array['ParentNo'] = $Accounting_Links_11->account_id;
            }
        }
        $Parent_recievable = FALSE;
        if (isset($Filtered_array['type_of_account']) && $Filtered_array['type_of_account'] == 1) {  //لتحديد حساب الاب الخاص بالذمم المدينة
            $Accounting_Links_10 = ORM::factory('Accounting_Links', 10);
            if ($Accounting_Links_10->loaded() && !empty($Accounting_Links_10->account_id)) {
                $Parent_recievable = TRUE;
                $Filtered_array['ParentNo'] = $Accounting_Links_10->account_id;
            }
        }

        if (($this->Add && empty($type_of_account) && !$objj->loaded()) || ($this->Edit && $objj->loaded() && empty($objj->type_of_account)) || ($this->E_Payables && $objj->loaded() && $objj->type_of_account == 2) || ($this->A_Payables && $Parent_payable && (!$objj->loaded()) && ($type_of_account == 2)) || ($this->E_Receivables && $objj->loaded() && $objj->type_of_account == 1) || ($this->A_Receivables && $Parent_recievable && (!$objj->loaded()) && ($type_of_account == 1))) {
            //delete this to cant change it
            if ($objj->loaded()) {
                unset($Filtered_array['ParentNo']);
                unset($Filtered_array['OpenBalance']);
                unset($Filtered_array['Credit']);
                unset($Filtered_array['Debit']);
                $is_exists = true;
            } else {
                $Filtered_array['OpenBalance'] = 0;
                $Filtered_array['Credit'] = 0;
                $Filtered_array['Debit'] = 0;
            }

            $objj->values($Filtered_array);

            $extra_rules = Validation::factory($Filtered_array);
            if ((isset($Filtered_array['type_of_account']) && $Filtered_array['type_of_account'] == 2) || $objj->type_of_account === 2) {
                $extra_rules->rule('bank', 'not_empty');
                $extra_rules->rule('iban', 'not_empty');
            }

            try {
                if ($objj->save($extra_rules)) {
                    $results['Success'] = array(
                        'title' => Lang::__('Done'),
                        'content' => Lang::__('Saved_successfully'),
                    );

                    if (isset($is_exists)) {
                        //Reports::AddReport('Accounts', 'edit', $objj->id); //تسجيل تقرير بالعملية
                    } else {
                        //Reports::AddReport('Accounts', 'add', $objj->id); //تسجيل تقرير بالعملية
                    }
                }
            } catch (ORM_Validation_Exception $e) {
                $errors = $e->errors('');
                $results['Errors'] = General::ArrayToString(General::CatchErrorMSGSAjax($errors));
            }
        } else {
            if (!($this->A_Payables && $Parent_payable && (!$objj->loaded()) && ($type_of_account == 2)) && !$Parent_payable) {
                $results['Errors'] = Lang::__('Please_Link_Account_For_Payables');
            } elseif (!($this->A_Receivables && $Parent_recievable && (!$objj->loaded()) && ($type_of_account == 1)) && !$Parent_recievable) {
                $results['Errors'] = Lang::__('Please_Link_Account_For_recievable');
            } else {
                $results['Errors'] = Lang::__('You_dont_have_permission_to_access_this_page');
            }
        }





        echo json_encode($results);
    }

    public function action_error($error) {
        $view = View::factory('errors')
                ->set('error', $error);
        $this->response->body($view);
    }

    /*
     * Ajax check for validate AccNo if it unique
     */

    public function action_UniqueAccNo() {
        $post = $this->request->post();
        $obj = ORM::factory('Accounting_Accounts')
                ->where(DB::expr('lower(AccNo)'), '=', mb_strtolower($post['AccNo']))
                ->find();
        $result = array();
        $result['Founded'] = FALSE;
        if ($obj->loaded()) {
            $result['Founded'] = TRUE;
        }



        echo json_encode($result);
    }
    public function action_GetUniqueAccNo() {
        $result = array();
        $post = $this->request->post();
        
        if(isset($post['AccNo'])){
        $obj = ORM::factory('Accounting_Accounts')
                ->where(DB::expr('lower(AccNo)'), '=', mb_strtolower($post['AccNo']))
                ->find();
        if($obj->loaded()){
            $result['Founded'] = TRUE;
            $obj2 = ORM::factory('Accounting_Accounts')
                ->where(DB::expr('lower(ParentNo)'), '=', $obj->id)
                ->find_all();
            $arr = array();
            $count = 0;
            foreach($obj2 as $row){
                $count++;
                $arr = (explode(".",$row->AccNo));
            }
            if($count == 0){
                $result['Founded'] = $post['AccNo'].'.1';
            }else{
                $result['Founded'] = $post['AccNo'].'.'.($arr[sizeof($arr) - 1] +1);
            }
        
            
        }else{
            $result['Founded'] = false;
        }
           
        }else{
            $obj = ORM::factory('Accounting_Accounts')
                    ->where('ParentNo' , 'IS',null)
                ->order_by('AccNo','ASC')
                ->find_all();
            foreach($obj as $row){
                $result['Founded'] = $row->AccNo + 1;
            }
        }


        echo json_encode($result);
    }
    /*
     * Ajax check for validate AccNo if it unique
     */

    public function action_UniqueAR_Name() {
        $post = $this->request->post();
        $obj = ORM::factory('Accounting_Accounts')
                ->where(DB::expr('lower(AccName_ar)'), '=', mb_strtolower($post['AccName_ar']))
                ->find();
        $result = array();
        $result['Founded'] = FALSE;
        if ($obj->loaded()) {
            $result['Founded'] = TRUE;
        }

        //if edit exists
        if (isset($post['idofelement']) && (intval($post['idofelement']) == $obj->id) && (mb_strtolower($obj->AccName_ar) == mb_strtolower($post['AccName_ar']))) {
            $result['Founded'] = FALSE;
        }

        echo json_encode($result);
    }

    /*
     * Ajax check if movment happen on account
     */

    public function action_MovmentHappen() {
        $result = array();
        $post = $this->request->post();
        if ($post['account_id'] == 0) {
            $result['Founded'] = FALSE;
        } else {
            $obj = ORM::factory('Accounting_Accounts', $post['account_id']);
            $res = Accounts::Move_on_account($obj);
            $result['Founded'] = $res;
        }
        echo json_encode($result);
    }

}

/*
 * All Description for Reports
 * delete حذف حساب 
 * add اضاف
 * edit عدل
 */

// End Accounts
