<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Acceptinbox extends Controller_Template_Base {

    public $Add = FALSE;
    public $Browse = FALSE;
    public $Edit = FALSE;
    public $Delete = FALSE;

    public function __construct(Request $request, Response $response) {
        // You must call parent::__construct at some point in your function
        parent::__construct($request, $response);
        // Do whatever else you want

        $this->Add = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'A_AcceptInbox')));
        $this->Browse = $this->user_online->hasRole('roles', ORM::factory('Role', array('name' => 'B_AcceptInbox')));
    }

    public function action_index() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('acceptinbox_sent');
            $this->template->title = $title;
            $this->template->layout = new View('system/Acceptinbox/view_all');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }

    public function action_inbox() {
        if ($this->Add || $this->Browse || $this->Edit || $this->Delete) {
            $title = Lang::__('A_AcceptInbox');
            $this->template->title = $title;
            $this->template->layout = new View('system/Acceptinbox/view_all_inbox');
            $this->template->layout->title = $title;
            $this->template->layout->Add = $this->Add;
            $this->template->layout->lang = $this->lang;
        } else {
            $this->template->layout = new View('system/show_msg');
            $this->template->layout->class_color = 'danger';
            $this->template->layout->msg = Lang::__('You_dont_have_permission_to_access_this_page');
        }
    }
    public function action_sendArchive(){
        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['part1']) ? NULL : $Filtered_array['part1'];
        $objj = ORM::factory('Contactperson_Message')->where('id', '=', $par1)->find();
        $objj->manual_archive = $Filtered_array['target'];
        $objj->save();
        $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
        echo json_encode($results);
    }
    private function IncreaseNumber() {
        $accept_number = 0;
        $objj = ORM::factory('Contactperson_Message')->where('accept_number', '!=', 0)->find_all();
        foreach ($objj as $rows) {
            $accept_number = $rows->accept_number;
        }
        return $accept_number + 1;
    }

    public function action_ToDB() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['part1']) ? NULL : $Filtered_array['part1'];

        $objj = ORM::factory('Contactperson_Message')->where('speach_id', '=', $par1)->find();

       // $objj->accept_number = $this->IncreaseNumber();
        $objj->contact_person = $Filtered_array['target'];

        try {
            if ($objj->save()) {
                $objj2 = ORM::factory('Speeches1', $par1);
                if ($objj2->loaded()) {
                    $objj2->Accepted = 1;
                    $objj2->save();
                    $this->addNewLetter(array('text1'=>$objj->description,'directory'=>$objj->upload_path.$objj->attachment));
                }
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        echo json_encode($results);
    }

    public function action_ToDBinbox() {
        $results = array();

        $req = Request::current(); //fillter requset
        $Filtered_array = Search::action_Filtered_array($req->post());
        $par1 = empty($Filtered_array['part1']) ? NULL : $Filtered_array['part1'];

        $objj = ORM::factory('Contactperson_Message')->where('id', '=', $par1)->find();

        //$objj->accept_number = $this->IncreaseNumber();
        $objj->contact_person = $Filtered_array['target'];
        try {
            if ($objj->save()) {
                $this->addNewLetter(array('text1'=>$objj->description,'directory'=>$objj->upload_path.$objj->attachment));
                $objj2 = ORM::factory('Speeches1', $objj->speach_id);
                if ($objj2->loaded()) {
                    $objj2->Accepted = 1;
                    $objj2->save();
                }
                $results['Success'] = array(
                    'theme' => 'lime', //teal,amethyst,ruby,tangerine,lemon,lime,ebony,smoke
                    'horizontalEdge' => 'top', //top,bottom
                    'verticalEdge' => 'right', //right,left
                    'heading' => '',
                    'life' => '2000', //1000 is 1 second
                    'text' => Lang::__('Saved_successfully'),
                );
            }
        } catch (ORM_Validation_Exception $e) {

            $errors = $e->errors('');
            $results['Errors'] = General::CatchErrorMSGSAjax($errors);
        }
        //echo json_encode($results);
    }

    public function action_GetData() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Speeches')
                ->where('type', '=', 1)
                ->order_by('id', 'DESC');



        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['id'])) {
                $Name1 = $post['id'] - 1000;
                $All_ORM->where(DB::expr('lower(accept_number)'), 'LIKE', mb_strtolower("%$Name1%"));
            }
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->where(DB::expr('lower(name)'), 'LIKE', mb_strtolower("%$Name%"));
            }
            if (!empty($post['email'])) {
                $email = $post['email'];
                $All_ORM->where(DB::expr('lower(email)'), 'LIKE', mb_strtolower("%$email%"));
            }
            if (!empty($post['message'])) {
                $cel_phone = $post['message'];
                $All_ORM->where(DB::expr('lower(message)'), 'LIKE', mb_strtolower("%$cel_phone%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */

        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            //($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Contactperson/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            //($this->Delete) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            $buttons .= '<a data-url="' . URL::base() . 'Acceptinbox/details/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>';

            if ($value->Accepted == 1) {
                $accepted_status = Lang::__('Community_service_accepted');
            } else {
                $accepted_status = Lang::__('Wait');
            }
            $users2 = ORM::factory('Contactperson_Getinfo')->where('id', '=', ltrim($value->email, 'c'))->find_all();

            $emails = "";
            foreach ($users2 as $vals) {
                // $datas = ORM::factory('Contactperson_Message')->where('contact_person','=',$vals->id)->find_all();
                $emails = $vals->email;
            }

            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $value->id + 1000,
                $value->name,
                $emails,
                $value->message,
                $accepted_status,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_GetDataInbox() {
        $post = $this->request->post();
        $order = $post['order']; //Get how table order from datatable
        /*
         * All coulums will shown in table
         */
        $ALL_coulums = array(
            1 => "id",
        );

        $All_ORM = ORM::factory('Contactperson_Message')
                //->where('speach_id', '=', null)
                ->order_by('id', 'DESC');



        $Succesful_msg = Lang::__('Action_successfully_has_been_completed_Well_done');
        $C_Acti_status = "OK";

        /*
         * If Action exists
         */
        if (isset($post['customActionName'])) {
            switch ($post['customActionName']) {
                case 'Delete':

                    break;


                default:
                    break;
            }
        }


        /*
         * if search exists
         */
        if (isset($post['action']) && (!is_array($post['action'])) && mb_strtolower($post['action']) == 'filter') {
            if (!empty($post['id'])) {
                $Name1 = $post['id'] - 1000;
                $All_ORM->where(DB::expr('lower(id)'), 'LIKE', mb_strtolower("%$Name1%"));
            }
            if (!empty($post['name'])) {
                $Name = $post['name'];
                $All_ORM->where(DB::expr('lower(name)'), 'LIKE', mb_strtolower("%$Name%"));
            }
            if (!empty($post['message'])) {
                $cel_phone = $post['message'];
                $All_ORM->where(DB::expr('lower(description)'), 'LIKE', mb_strtolower("%$cel_phone%"));
            }
        }

        /*
         * Paging
         */
        $All_ORM->reset(FALSE);
        $iTotalRecords = $All_ORM->count_all();

        $iDisplayLength = intval($post['length']);
        $iDisplayLength = $iDisplayLength < 0 ? $iTotalRecords : $iDisplayLength;
        $iDisplayStart = intval($post['start']);
        $sEcho = intval($post['draw']);

        $records = array();
        $records["data"] = array();

        $end = $iDisplayStart + $iDisplayLength;
        $end = $end > $iTotalRecords ? $iTotalRecords : $end;

        $All_ORM->offset($iDisplayStart);
        $All_ORM->limit($iDisplayLength);


        /*
         * Prepare JSON Array
         */
        foreach ($All_ORM->find_all() as $value) {
            $buttons = '';
            //($this->Edit) ? $buttons.='<a href="' . URL::base() . 'Contactperson/AE/' . $value->id . '" class="btn btn-xs default"><i class="fa fa-edit"></i> ' . Lang::__('Edit') . '</a>' : NULL;
            //($this->Delete) ? $buttons.='<a par1="' . $value->id . '" Dtitle="' . Lang::__('Alert') . '" Dcontent="' . Lang::__('Are_you_sure_you_want_to_delete_it') . '" confirmButton="' . Lang::__('Yes') . '" cancelButton="' . Lang::__('Cancel') . '" class="btn btn-xs red Delete"> ' . Lang::__('Delete') . '</a>' : NULL;
            $buttons .= '<a data-url="' . URL::base() . 'Acceptinbox/detailsInbox/' . $value->id . '" class="btn btn-xs default ViewD" data-toggle="modal"><i class="fa fa-eye"></i> ' . Lang::__('Browse') . '</a>';

            if ($value->contact_person != null) {
                $accepted_status = Lang::__('Community_service_accepted');
            } else {
                $accepted_status = Lang::__('Wait');
            }
            //$users2 = ORM::factory('Contactperson_Getinfo')->where('id', '=', ltrim($value->email, 'c'))->find_all();

            $emails = "";
            //foreach ($users2 as $vals) {
            // $datas = ORM::factory('Contactperson_Message')->where('contact_person','=',$vals->id)->find_all();
            //  $emails = $vals->email;
            //}
            $id_sender = '-';
            if ($value->accept_number != 0) {
                $id_sender = $value->accept_number;
            }
            $im = Lang::__('very_important');
                if ($value->important == 0) {
                    $im = Lang::__('very_important');
                } else if ($value->important == 1) {
                    $im = Lang::__('important-s');
                } else {
                    $im = Lang::__('normal-s');
                }
            $records["data"][] = array(
                '<input type="checkbox" name="id[]" value="' . $value->id . '">',
                $id_sender,
                $value->name,
                $value->description,
                $im,
                $accepted_status,
                $buttons,
            );
        }
        if (isset($post["customActionType"]) && $post["customActionType"] == "group_action") {
            $records["customActionStatus"] = $C_Acti_status; // pass custom message(useful for getting status of group actions)
            $records["customActionMessage"] = $Succesful_msg; // pass custom message(useful for getting status of group actions)
        }

        $records["draw"] = $sEcho;
        $records["recordsTotal"] = $iTotalRecords;
        $records["recordsFiltered"] = $iTotalRecords;

        echo json_encode($records);
    }

    public function action_details() {
        if (($this->Browse)) {
            $view = new View('system/Acceptinbox/view_details');
            $par1 = $this->request->param('par1');

            $Obj = ORM::factory('Contactperson_Message')->where('speach_id', '=', $par1)->find_all();
            $objj2 = ORM::factory('Speeches', $par1);
            if ($objj2->loaded()) {
                $view->set('is_ver', $objj2->Accepted);
                $view->set('number', $objj2->id);
                $im = Lang::__('very_important');
                if ($objj2->important == 0) {
                    $im = Lang::__('very_important');
                } else if ($objj2->important == 1) {
                    $im = Lang::__('important-s');
                } else {
                    $im = Lang::__('normal-s');
                }

                $view->set('important', $im);
                $view->set('archive_url', $objj2->archive_url);
                $view->set('attachments', $objj2->upload_files);
                $view->set('Obj2', $objj2);
            }
            $view->set('par1', $par1);
            $view->set('Obj', $Obj);
            $view->set('lang', $this->lang);
            $this->response->body($view);
        }
    }

    public function action_detailsInbox() {
        if (($this->Browse)) {
            $view = new View('system/Acceptinbox/view_details_inbox');
            $par1 = $this->request->param('par1');

            $Obj = ORM::factory('Contactperson_Message', $par1);
            if ($Obj->loaded()) {
                $view->set('Obj', $Obj);
            }
            $view->set('par1', $par1);

            $view->set('lang', $this->lang);
            
            $this->response->body($view);
        }
    }
public function action_Delete() {
        $results = array();

        if ($this->Delete || true) {
            $req = Request::current(); //fillter requset
            $Filtered_array = Search::action_Filtered_array($req->post());

            $Obj = ORM::factory('Contactperson_Message', $_GET['id']);
                try {
                    $Obj->delete();
                   
                    
                        $results['Success'] = array(
                            'title' => Lang::__('Done'),
                            'content' => Lang::__('Deletion has been successfully'),
                        );
                    
                } catch (ORM_Validation_Exception $e) {

                    $errors = $e->errors('');
                    $results['Errors'] = array(
                        'title' => Lang::__('Error'),
                        'content' => General::CatchErrorMSGSAjax($errors),
                    );
                }
            
        } else {
            $results['Errors'] = array(
                'title' => Lang::__('Error').'#1',
                'content' => Lang::__('You_dont_have_permission_to_do_this_action'),
            );
        }

        echo json_encode($results); 
        //$this->redirect('acceptinbox/inbox');
    }
    public function addNewLetter($Filtered_array) {

        $results = array();


        $objj = ORM::factory('Letters_Applications');
        if (true) {
            $objj->Created_by = $this->user_online->id;
            $objj->Created_date = date("Y-m-d H:i:s");
            $Letter = ORM::factory('Letters_Letters', 13);
            $objj->letter = 13;
            $objj->values($Filtered_array);


            $ChAccess = $objj->CheckUserApplicationAccess($objj, $Letter, $this->user_online); //لفحص هل الطلب لرؤساء الاقسام فقط ام للجميع

            $numbers = '';
            if ($ChAccess) {
                $CheckApprovalsStaff = $Letter->CheckApprovalsStaff($Letter, $this->user_online);

                if (empty($CheckApprovalsStaff) && $Letter->loaded() && empty($Letter->is_deleted)) {

                    $objj->values($Filtered_array);
                   // $objj->attachment = $Filtered_array['attachment'];
                   // $objj->directory =  $Filtered_array['directory'];;
                    try {
                        $extra_rules = General::Jquery_To_ORM_Rules($Filtered_array, $objj->AdminRules($objj, $Letter, FALSE));
                        if ($objj->save($extra_rules)) {
//في حالة اضافة جديد فقط
                            if (empty($objj->last_update_date)) {
//بداية انشاء علاقات الموافقات المطلوبة...
                                $ApprovalStep = $Letter->ApprovalStep->where('is_deleted', '=', NULL)->order_by('order')->find_all();
                                $department_array = array();
                                $department_array_SMS = array();
                                foreach ($ApprovalStep as $value) {
                                    $department = $value->department;
                                    if (empty($department)) {
//يعني ان الموافقة تتعلق بقسم الموظف
                                        $department = $this->user_online->Employee_Information->Department->id;
                                    }
                                    // if (!in_array($department, $department_array)) {
                                    array_push($department_array, array('order' => $value->order, 'department' => $department));
                                    // }
                                    if (!in_array($department, $department_array_SMS)) {
                                        array_push($department_array_SMS, $department);
                                    }
                                }
                                //print_r($department_array);
                                foreach ($department_array as $value) {
//لعدم تكرار نفس القسم للموافقة
                                    $Prev = ORM::factory('Letters_Applications_Approvals')
                                            ->where('department', '=', $value['department'])
                                            ->where('application_id', '=', $objj->id)
                                            ->find();
                                    if (!$Prev->loaded() || true) {
                                        $O = ORM::factory('Letters_Applications_Approvals');
                                        $O->order = $value['order'];
                                        $O->department = $value['department'];
                                        $O->application_id = $objj->id;
                                        $O->Created_by = $this->user_online->id;
                                        $O->Created_date = date("Y-m-d H:i:s");
                                        $O->save();
                                        if (in_array($value['department'], $department_array_SMS)) {
                                            $dep_ids = array(0);

                                            $users = ORM::factory('Hr_Employment_Applications')->where('department', '=', $value['department'])->find_all();

                                            foreach ($users as $vals) {
                                                if (!empty($vals->hr_position)) {
                                                    //في حال كان مدير او نائب مدير سيظهر له الطلب
                                                    $d = ORM::factory('General_Hr_Departments')
                                                            ->and_where_open()
                                                            ->or_where('director', '=', $vals->hr_position)
                                                            ->or_where('deputy_director', '=', $vals->hr_position)
                                                            ->and_where_close()
                                                            ->where('is_deleted', '=', NULL)
                                                            ->find_all();

                                                    foreach ($d as $value11) {
                                                        array_push($dep_ids, $value11->id);
                                                    }
                                                }
                                                if (in_array($value['department'], $dep_ids)) {
                                                    if (strlen($numbers) > 1) {
                                                        $numbers = $numbers . ',' . $vals->mobile;
                                                    } else {
                                                        $numbers = $vals->mobile;
                                                    }
                                                    try {
                                                        $Noti1 = ORM::factory("Notifications");
                                                        $Noti1->notification_cat = 2;
                                                        $Noti1->first_ref = $O->id;
                                                        $Noti1->affected_user = $vals->id;
                                                        $Noti1->effected_by = $this->user_online->id;
                                                        $Noti1->Created_date = date("Y-m-d H:i:s");
                                                        $Noti1->save();
                                                        $viewMessageBody = View::factory('system/email_message');
                                                        $viewMessageBody->username = $this->user_online->name_ar;
                                                        $viewMessageBody->type = 1;
                                                        //    Mailer::SendEmail(null, null, $vals->email, "jaleat email", $viewMessageBody);
                                                    } catch (Exception $ex) {
                                                        echo $ex;
                                                    }
                                                }
                                            }
                                            unset($department_array_SMS[array_search($vals, $department_array_SMS)]);
                                        }
                                    }
                                }
//نهاية انشاء علاقات الموافقات المطلوبة...    
                            }


                            $results['Success'] = array(
                                'title' => Lang::__('Done'),
                                'phones' => $numbers,
                                'content' => Lang::__('Saved_successfully'),
                                'redirect' => URL::base() . 'Letters_Applications/index/' . $Letter->id,
                            );
                        }
                    } catch (ORM_Validation_Exception $e) {

                        $errors = $e->errors('');

                        $Lang_Error = array();
                        foreach ($errors as $key => $value) {
                            $srting = '';
                            if (is_array($value)) {
                                foreach ($value as $subval) {
                                    $srting_sub = '';
                                    $errr = explode('*', $subval);
                                    if (count($errr) > 0) {
                                        $i = 0;
                                        foreach ($errr as $aaa) {
                                            $ss = NULL;
                                            if ($i == 0) {
                                                $F = ORM::factory('Letters_Fields')->where('col_name', '=', $aaa)->where('letter', '=', $Letter->id)->find();
                                                if ($F->loaded()) {
                                                    $ss = $F->{'name_' . $this->lang};
                                                }
                                            }
                                            if (empty($ss)) {
                                                $srting_sub .= Lang::__($aaa) . ' ';
                                            } else {
                                                $srting_sub .= $ss . ' ';
                                            }

                                            $i++;
                                        }
                                        array_push($Lang_Error, $srting_sub);
                                    }
                                }
                            } else {
                                $errr = explode('*', $value);
                                if (count($errr) > 0) {

                                    foreach ($errr as $aaa) {
                                        $ss = NULL;
                                        if ($i == 0) {
                                            $F = ORM::factory('Letters_Fields')->where('col_name', '=', $aaa)->where('letter', '=', $Letter->id)->find();
                                            if ($F->loaded()) {
                                                $ss = $F->{'name_' . $this->lang};
                                            }
                                        }
                                        if (empty($ss)) {
                                            $srting .= Lang::__($aaa) . ' ';
                                        } else {
                                            $srting .= $ss . ' ';
                                        }

                                        $i++;
                                    }
                                    array_push($Lang_Error, $srting);
                                }
                            }
                        }
                        $results['Errors'] = array(
                            'title' => Lang::__('Error'),
                            'content' => General::ArrayToString($Lang_Error)
                        );
                    }
                }
            } else {
                $results['Errors'] = array(
                    'title' => Lang::__('Error'),
                    'content' => Lang::__('You_dont_have_permission_to_do_this_action')
                );
            }
        }else{
            echo "Not Loaded";
        }



        echo json_encode($results);
    }

}
